/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.betternether.blocks;

import java.util.Collections;
import java.util.List;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.betterx.bclib.behaviours.interfaces.BehaviourPlant;
import org.betterx.bclib.blocks.BasePlantBlock;
import org.betterx.bclib.util.LootUtil;
import org.betterx.betternether.blocks.materials.Materials;
import org.betterx.betternether.interfaces.SurvivesOnGrassSoil;

abstract class BaseBlockNetherGrass
extends BasePlantBlock
implements BehaviourPlant {
    private static final VoxelShape SHAPE = BaseBlockNetherGrass.m_49796_((double)4.0, (double)0.0, (double)4.0, (double)14.0, (double)12.0, (double)14.0);

    public BaseBlockNetherGrass() {
        super(Materials.makeNetherGrass(MapColor.f_283861_).m_222979_(BlockBehaviour.OffsetType.XZ));
    }

    @Environment(value=EnvType.CLIENT)
    public float m_7749_(BlockState state, BlockGetter view, BlockPos pos) {
        return 1.0f;
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter view, BlockPos pos, CollisionContext ePos) {
        Vec3 vec3d = state.m_60824_(view, pos);
        return SHAPE.m_83216_(vec3d.f_82479_, vec3d.f_82480_, vec3d.f_82481_);
    }

    public BlockState m_7417_(BlockState state, Direction facing, BlockState neighborState, LevelAccessor world, BlockPos pos, BlockPos neighborPos) {
        if (!this.m_7898_(state, (LevelReader)world, pos)) {
            return Blocks.f_50016_.m_49966_();
        }
        return state;
    }

    public List<ItemStack> m_49635_(BlockState state, LootParams.Builder builder) {
        ItemStack tool = (ItemStack)builder.m_287261_(LootContextParams.f_81463_);
        if (LootUtil.isCorrectTool((ItemLike)this, (BlockState)state, (ItemStack)tool)) {
            return Collections.singletonList(new ItemStack((ItemLike)this.m_5456_()));
        }
        return super.m_49635_(state, builder);
    }

    public static class OnEverything
    extends BaseBlockNetherGrass
    implements SurvivesOnGrassSoil {
        public boolean m_7898_(BlockState state, LevelReader level, BlockPos pos) {
            return this.canSurviveOnTop(level, pos);
        }

        public boolean isTerrain(BlockState state) {
            return SurvivesOnGrassSoil.super.isTerrain(state);
        }
    }
}

